<?php

namespace Sso\BackendBundle\Api;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Symfony\Component\HttpKernel\Log\LoggerInterface;

class Manager
{

    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    protected $container;


    /**
     * @var LoggerInterface
     */
    protected $log;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
        $this->log = $this->container->get('logger');
    }

    /**
     * @return Import\Index
     */
    public function import()
    {
        if (!isset($this->setter['import'])) {
            $this->setter['import'] = new Import\Index($this);
        }

        return $this->setter['import'];
    }

    /**
     * JMS Serializer
     *
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->getContainer()->get('jms_serializer');
    }

    /**
     * Sy2 configuration
     * and some helper
     *
     * @return Configuration\Index
     */
    public function configuration()
    {
        if (!isset($this->setter['configuration'])) {
            $this->setter['configuration'] = new Configuration\Index($this);
        }

        return $this->setter['configuration'];
    }

    /**
     *
     * @return Helper\Factory
     */
    public function helper()
    {
        if (!isset($this->setter['helper'])) {
            $this->setter['helper'] = new Helper\Factory($this);
        }

        return $this->setter['helper'];
    }

    /**
     * @return \Symfony\Component\Validator\Validator\LegacyValidator
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * @return \Guzzle\Service\Client
     */
    public function client()
    {
        return $this->container->get('guzzle.client');
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }

    /**
     * @return LoggerInterface
     */
    public function log()
    {
        if (!isset($this->setter['log'])) {
            $this->setter['log'] = $this->log;
        }
        return $this->setter['log'];
    }
}