<?php

/**
 *
 * @class AdminController
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
// these import the "@Route" and "@Template" annotations
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class AdminController
 * @package Sso\BackendBundle\Controller
 */
class AdminController extends Controller
{
    /**
     * @Route("/", name="_admin_backend_index")
     * @return Response
     */
    public function indexAction()
    {
        return $this->render('@SsoBackend/admin/index.html.twig');
    }

    /**
     * @Route("/welcome", name="_admin_backend_welcome")
     * @return Response
     */
    public function welcomeAction()
    {
        return $this->render('@SsoBackend/admin/welcome.html.twig');
    }

    /**
     * @Route("/changelog", name="_admin_backend_changelog")
     * @return Response
     */
    public function changelogAction()
    {
        return $this->render('@SsoBackend/admin/changelog.html.twig');
    }

}
