<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\BackendBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;

class ServiceController extends WsAbstractController
{

    /**
     * @Route("/list", name="_admin_backend_service")
     * @return Response
     */
    public function listAction()
    {
        return $this->render(
            '@SsoBackend/service/list.html.twig',
            ['services' => $this->databaseManager()->serviceProvider()->service()->getAll()]
        );
    }

    /**
     * @Route("/add", name="_admin_backend_service_add")
     * @return Response
     */
    public function addAction()
    {
        return $this->render('@SsoBackend/service/add.html.twig');
    }

    /**
     * @Route("/delete", name="_admin_backend_service_delete")
     * @return Response
     */
    public function deleteAction()
    {
        return $this->render('@SsoBackend/service/delete.html.twig');
    }

    /**
     * @Route("/show", name="_admin_backend_service_show")
     * @return Response
     */
    public function showAction()
    {
        return $this->render('@SsoBackend/service/show.html.twig');
    }

}
