<?php

namespace Sso\BackendBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Import
 *
 * @ORM\Table(name="objects_import_config")
 * @ORM\Entity
 */
class Import
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="column_name", type="string", length=255)
     */
    private $columnName;

    /**
     * @var string
     *
     * @ORM\Column(name="object_value_id", type="string", length=255)
     */
    private $objectValueId;


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set columnName
     *
     * @param string $columnName
     *
     * @return Import
     */
    public function setColumnName($columnName)
    {
        $this->columnName = $columnName;

        return $this;
    }

    /**
     * Get columnName
     *
     * @return string
     */
    public function getColumnName()
    {
        return $this->columnName;
    }

    /**
     * Set objectValueId
     *
     * @param string $objectValueId
     *
     * @return Import
     */
    public function setObjectValueId($objectValueId)
    {
        $this->objectValueId = $objectValueId;

        return $this;
    }

    /**
     * Get objectValueId
     *
     * @return string
     */
    public function getObjectValueId()
    {
        return $this->objectValueId;
    }
}

