<?php

/**
 *
 * @class LanguageController
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\DemoBundle\Controller;

use Sso\DemoBundle\Controller\BaseController;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\Form\Extension\Core\Type as FormType;

/**
 * Class LanguageController
 * @package Sso\DemoBundle\Controller
 */
class LanguageController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_language_show")
     * @Template()
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Code', FormType\ChoiceType::class, array(
                'choices' => $this->apiM()->form()->getLanguageIds(),
                'required' => false
            ))
            ->add('build xml and make webservice request', FormType\SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'Language', 'Show');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlLanguageShow($params = array())
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <Language>
                            <Show>
                                    <LanguageType>
                                        " . $this->_xmlBuildLanguageIdentifier($params) . "
                                    </LanguageType>
                            </Show>
                        </Language>
                    </SsoRequest>";
    }
}
