<?php

/**
 * Class ObjectValueController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\Form\Extension\Core\Type as FormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

/**
 * Class ObjectValueController
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\DemoBundle\Controller
 */
class ObjectValueController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_object_value_show")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', EntityType::class, [
                'class' => 'SsoWebservicesObjectBundle:ObjectAttributeValue',
                'choice_label' => 'Id',
                'required' => false,
            ])
            ->add('build xml and make webservice request', SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'ObjectValue', 'Show');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectValueShow($params = [])
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <ObjectValue>
                            <Show>
                                <ObjectValueType>
                                    " . $this->xmlBuildObjectValueShowIdentifier($params) . "
                                </ObjectValueType>
                            </Show>
                        </ObjectValue>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectValueShowIdentifier($params, $prefix = '')
    {
        $keys = ['Id'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * Build xml to identify type
     *
     * @param array $keys
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildIdentifier($keys, $params, $prefix = '')
    {
        $xml = [];
        foreach ($keys as $key) {
            if (in_array($key, ['Id', 'LanguageCode'])) {
                $idx = $prefix . $key;
                if (!empty($params[$idx])) {
                    $xml[] = '<' . $key . '>' . $params[$idx]->getId() . '</' . $key . '>';
                }
            } else {
                $idx = $prefix . $key;
                if (!empty($params[$idx]) || $params[$idx] === 0) {
                    $xml[] = '<' . $key . '>' . $params[$idx] . '</' . $key . '>';
                }
            }
        }
        return implode("\n", $xml);
    }

    /**
     * @Route("/", name="_sso_demo_object_value_add")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('ObjectGuid', TextType::class)
            ->add('ObjectValue', TextType::class)
            ->add('LanguageCode', TextType::class)
            ->add('AttributeId', TextType::class)
            ->add('build xml and make webservice request', SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'ObjectValue', 'Add');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectValueAdd($params = [])
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <ObjectValue>
                            <Add>
                                <ObjectValueType>
                                " . $this->_xmlBuildObjectValueAddIdentifier($params) . "
                                </ObjectValueType>
                            </Add>
                        </ObjectValue>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function _xmlBuildObjectValueAddIdentifier($params, $prefix = '')
    {
        $xml = [];
        $keys = ['ObjectGuid', 'ObjectValue', 'LanguageCode', 'AttributeId'];

        foreach ($keys as $key) {
            $idx = $prefix . $key;
            if (!empty($params[$idx])) {
                $xml[] = '<' . $key . '>' . $params[$idx] . '</' . $key . '>';
            }
        }
        return implode("\n", $xml);
    }

    /**
     * @Route("/", name="_sso_demo_object_value_update")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function updateAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', EntityType::class, [
                'class' => 'SsoWebservicesObjectBundle:ObjectAttributeValue',
                'choice_label' => 'Id',
                'required' => true,
            ])
            ->add('Value', TextType::class)
            ->add('LanguageCode', EntityType::class, [
                'class' => 'SsoWebservicesObjectBundle:Language',
                'choice_label' => 'Id',
                'required' => false,
            ])
            ->add('build xml and make webservice request', SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'ObjectValue', 'Update');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectValueUpdate($params = [])
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <ObjectValue>
                            <Update>
                                <ObjectValueType>
                                    " . $this->xmlBuildObjectValueUpdateIdentifier($params) . "
                                </ObjectValueType>
                            </Update>
                        </ObjectValue>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectValueUpdateIdentifier($params, $prefix = '')
    {
        $keys = ['Id', 'Value', 'LanguageCode'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }

    /**
     * @Route("/", name="_sso_demo_object_value_delete")
     * @Template()
     *
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->_getFormDefaults($request))
            ->add($this->buildFormCredentials())
            ->add('Id', EntityType::class, [
                'class' => 'SsoWebservicesObjectBundle:ObjectAttributeValue',
                'choice_label' => 'Id',
                'required' => true,
            ])
            ->add('build xml and make webservice request', SubmitType::class)
            ->getForm();
        return $this->_getResponseFromForm($form, $request, 'ObjectValue', 'Delete');
    }

    /**
     * @var array $params
     * @return string
     */
    protected function _xmlObjectValueDelete($params = [])
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->_xmlCredentials($params) . "
                        <ObjectValue>
                            <Delete>
                                <ObjectValueType>
                                    " . $this->xmlBuildObjectValueDeleteIdentifier($params) . "
                                </ObjectValueType>
                            </Delete>
                        </ObjectValue>
                    </SsoRequest>";
    }

    /**
     * Build xml to identify type
     *
     * @param array $params
     * @param string $prefix
     * @return string
     */
    protected function xmlBuildObjectValueDeleteIdentifier($params, $prefix = '')
    {
        $keys = ['Id'];
        return $this->xmlBuildIdentifier($keys, $params, $prefix);
    }
}
