<?php

/**
 * Steps Base
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\UserIdentifierBundle\Model\Response\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Base
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
abstract class Base
{

    /**
     * @Serializer\SerializedName("Status")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("array<Sso\Tools\UserIdentifierBundle\Model\Response\Node\Error")
     * @var Error[]
     */
    private $Errors = array();

    /**
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     *
     * @return Error[]
     */
    public function getErrors()
    {
        return $this->Errors;
    }

}