<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\DefaultBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Stopwatch\Stopwatch;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

class DefaultController extends Controller
{

    /**
     * called when user tried to call ws
     * with wrong params / means no routing matched
     *
     * @Route("/",
     *     defaults={"_format": "xml"},
     *     condition="request.headers.get('Content-Type') matches '#^text/xml#i'"
     * )
     * @Method({"GET|POST"})
     */
    public function xmlAction(Request $request)
    {
        return array();
    }

    /**
     * Default service action - returns basic usage information
     *
     * @Method({"GET|POST"})
     * @Route("/")
     * @Template()
     */
    public function helpAction()
    {
        return array();
    }

}
