<?php

/**
 * Class AttributeController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

/**
 * Class AttributeController
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Controller
 */
class AttributeController extends AbstractController
{
    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Attribute->Show as $xmlRecord) {
            $this->worker()->attribute()->show($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function addAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');
        foreach ($xmlRequest->Attribute->Add as $xmlRecord) {
            $this->worker()->attribute()->add($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function updateAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Attribute->Update as $xmlRecord) {
            $this->worker()->attribute()->update($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function deleteAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Attribute->Delete as $xmlRecord) {
            $this->worker()->attribute()->delete($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showAllAction(Request $request)
    {
        die('@ToDo Object ShowAll');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showChildsAction(Request $request)
    {
        die('@ToDo Object ShowAll');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showParentsAction(Request $request)
    {
        die('@ToDo Object ShowAll');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }
}
