<?php

/**
 * Class ObjectValueController
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

/**
 * Class ObjectValueController
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Controller
 */
class ObjectValueController extends AbstractController
{
    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->ObjectValue->Show as $xmlRecord) {
            $this->worker()->objectValue()->show($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function addAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->ObjectValue->Add as $xmlRecord) {
            $this->worker()->objectValue()->add($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function updateAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->ObjectValue->Update as $xmlRecord) {
            $this->worker()->objectValue()->update($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function deleteAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->ObjectValue->Delete as $xmlRecord) {
            $this->worker()->objectValue()->delete($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            $status,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * Show All
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showChildsAction(Request $request)
    {
        die('@ToDo Object ShowAll');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            200,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }

    /**
     * Show Parents
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function showParentsAction(Request $request)
    {
        die('@ToDo Object ShowAll');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response(
            $this->apiM()->responseBuilder()->output(),
            200,
            ['Content-Type' => 'text/xml; charset=UTF-8']
        );
    }
}
