<?php

namespace Sso\Webservices\ObjectBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Stopwatch\Stopwatch;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsRoute;
use LifeStyle\Tools\WebserviceBundle\Configuration\WsSecurity;

class TypeController extends AbstractController
{
    /**
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function addAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');
        foreach ($xmlRequest->Type->Add as $xmlRecord) {
            $this->worker()->type()->add($xmlRecord);
        }
        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }
        return new Response($this->apiM()->responseBuilder()->output(), $status,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function showAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');
        foreach ($xmlRequest->Type->Show as $xmlRecord) {
            $this->worker()->type()->show($xmlRecord);
        }
        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }
        return new Response($this->apiM()->responseBuilder()->output(), $status,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function updateAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');
        foreach ($xmlRequest->Type->Update as $xmlRecord) {
            $this->worker()->type()->update($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function deleteAction(Request $request)
    {
        $xmlRequest = $request->attributes->get('XmlRequest');
        foreach ($xmlRequest->Type->Delete as $xmlRecord) {
            $this->worker()->type()->delete($xmlRecord);
        }

        $status = 200;
        if ($this->apiM()->errors()->hasErrors()) {
            $status = 400;
        }

        return new Response($this->apiM()->responseBuilder()->output(), $status,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }


    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function showAllAction(Request $request)
    {
        die('@ToDo');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response($this->apiM()->responseBuilder()->output(), 200,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

    /**
     *
     * @Route("/")
     * @WsRoute()
     * @WsSecurity({"ServiceProvider", "ServiceCountry", "ServiceTrigger"})
     * @Method({"POST"})
     */
    public function showObjectsAction(Request $request)
    {
        die('@ToDo');

        $xmlRequest = $request->attributes->get('XmlRequest');

        foreach ($xmlRequest->Wordlets->Update as $xmlRecord) {
            $this->apiWorker()->update($xmlRecord);
        }

        return new Response($this->apiM()->responseBuilder()->output(), 200,
            array('Content-Type' => 'text/xml; charset=UTF-8'));
    }

}
