<?php

namespace Sso\Webservices\ObjectBundle\Database\Data\TreeObject\Dto;

/**
 * Sso SSO Admin Frontend
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
final class Object
{
    /**
     * @var string
     */
    private $guid;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $lowerName;

    /**
     * @var string
     */
    private $treeId;

    /**
     * @var string
     */
    private $referenceId;

    /**
     * @var string
     */
    private $parentGuid;

    /**
     * @var string
     */
    private $typeId;

    /**
     * @var string
     */
    private $typeName;

    /**
     * @var string
     */
    private $typeOrder;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return Object
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Object
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getLowerName()
    {
        return $this->lowerName;
    }

    /**
     * @param string $lowerName
     * @return Object
     */
    public function setLowerName($lowerName)
    {
        $this->lowerName = $lowerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getTreeId()
    {
        return $this->treeId;
    }

    /**
     * @param string $treeId
     * @return Object
     */
    public function setTreeId($treeId)
    {
        $this->treeId = $treeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Object
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return Object
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return Object
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param string $typeName
     * @return Object
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeOrder()
    {
        return $this->typeOrder;
    }

    /**
     * @param string $typeOrder
     * @return Object
     */
    public function setTypeOrder($typeOrder)
    {
        $this->typeOrder = $typeOrder;
        return $this;
    }
}
