<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Database\Data\Type;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;
use Sso\Webservices\ObjectBundle\Entity\Type as EntityType;
use Sso\Webservices\ObjectBundle\Database\Repository\Factory as RepositoryFactory;

class Index
{

    /**
     * Doctrine Registry
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var RepositoryFactory
     */
    protected $repositoryFactory;

    /**
     * @param DoctrineRegistry $doctrineRegistry
     * @param RepositoryFactory $repoFactory
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, RepositoryFactory $repoFactory)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->repositoryFactory = $repoFactory;
    }

    /**
     *
     * @param EntityType $entity
     */
    public function save(EntityType $entity)
    {
        $this->entityManager->persist($entity);
        $this->entityManager->flush($entity);
    }

    /**
     *
     * @param EntityType $entity
     */
    public function delete(EntityType $entity)
    {
        $this->entityManager->remove($entity);
        $this->entityManager->flush($entity);
    }

}
