<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model;

use Sso\Webservices\ObjectBundle\Model\Request\Factory as RequestFactory;
use Sso\Webservices\ObjectBundle\Model\Response\Factory as ResponseFactory;
use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Model factory class
 */
class Factory
{

    /**
     * List of factory objects
     *
     * @var array
     */
    protected $factories = array();

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return RequestFactory
     */
    public function request()
    {
        if (!isset($this->factories['request'])) {
            $this->factories['request'] = new RequestFactory($this->apiM);
        }
        return $this->factories['request'];
    }

    /**
     * @return ResponseFactory
     */
    public function response()
    {
        if (!isset($this->factories['response'])) {
            $this->factories['response'] = new ResponseFactory($this->apiM);
        }
        return $this->factories['response'];
    }

    /**
     *
     * @return ApiManager
     */
    public function apiM()
    {

        return $this->apiM;
    }

}
