<?php

/**
 * Class AttributeGroup
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("AttributeGroupType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Delete
 */
class AttributeGroup
{

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @Assert\NotBlank(message = "attributeGroupDelete01##Invalid AttributeGroup ID##AttributeGroup Id should not be empty",)
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "attributeGroupDelete01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long",
     *      maxMessage = "attributeGroupDelete01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long",
     *      exactMessage = "attributeGroupDelete01##Invalid AttributeGroup ID##Your AttributeGroup Id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DeleteReferences")
     *
     * @var bool
     */
    private $deleteReferences = false;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences;
    }

    /**
     * @param boolean $deleteReferences
     * @return AttributeGroup
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = $deleteReferences ? true : false;

        return $this;
    }

}
