<?php

/**
 * Class AddType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class AddType
 *
 * @Serializer\XmlRoot("AddTypes")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Update
 */
class AddType
{

    /**
     * @Assert\NotBlank(message = "attributeGroupUpdateAddType00##Invalid TypeId##TypeId should not be empty",)
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "attributeGroupUpdateAddType00##Invalid Id##Id must be at least {{ limit }} characters long",
     *      maxMessage = "attributeGroupUpdateAddType00##Invalid Id##Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "attributeGroupUpdateAddType00##Invalid Id##Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TypeId")
     * @Serializer\XmlList(inline = true, entry="TypeId")
     *
     * @var string
     */
    private $typeId;

    /**
     * Get name
     *
     * @param string $typeId
     * @return string
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

}
