<?php

/**
 * Class Entity
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Request\Object\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Entity
 *
 * @Serializer\XmlRoot("ObjectType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Request\Object\Delete
 */
class Entity
{

    /**
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Guid")
     *
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "objectDelete01##Invalid guid##Your guid must be {{ limit }} characters long",
     *     maxMessage = "objectDelete01##Invalid guid##Your guid must be {{ limit }} characters long",
     *     exactMessage = "objectDelete01##Invalid guid##Your guid must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("ReferenceId")
     *
     * @Assert\Length(
     *     min = 1,
     *     max = 255,
     *     minMessage = "objectDelete02##Invalid reference id##Your reference id must be at least {{ limit }} characters long",
     *     maxMessage = "objectDelete02##Invalid reference id##Your reference id must not be bigger than {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $referenceId;

    /**
     * Set $guid
     *
     * @param string $guid
     * @return Type
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * Get $guid
     *
     * @return integer
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Entity
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

}
