<?php

namespace Sso\Webservices\ObjectBundle\Model\Request\Type\Show;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("TypeType")
 * @Serializer\ExclusionPolicy("all")
 */
class Entity
{

    /**
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "typeShow00##Invalid Id##Id must be at least {{ limit }} characters long",
     *      maxMessage = "typeShow00##Invalid Id##Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "typeShow00##Invalid Id##Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Assert\Length(
     *      min = 3,
     *      max = 255,
     *      minMessage = "typeShow01##Invalid Name##Name must be at least {{ limit }} characters long",
     *      maxMessage = "typeShow01##Invalid Name##Name cannot be longer than {{ limit }} characters",
     *      exactMessage = "typeShow01##Invalid Name##Name should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * Set id
     *
     * @param string $id
     * @return Type
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Type
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

}
