<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show;

use Sso\Webservices\ObjectBundle\Model\Response\Attribute\Base as AttributeGroupBase;
use Sso\Webservices\ObjectBundle\Entity\Attribute as EntityAttribute;
use Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show\Entity\Attribute as ResponseAttribute;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;
use Sso\Webservices\ObjectBundle\Model\Request\Attribute\Show\Entity\Attribute as RequestModel;

/**
 * Class Show
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\Attribute\Show
 */
class Show extends AttributeGroupBase
{
    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     * @var EntityAttribute[]
     */
    protected $attributeEntities;

    /**
     * @var int
     */
    protected $attributesCount;

    /**
     * @var RequestModel
     */
    protected $requestModel;

    /**
     * @param EntityAttribute[] $attributeEntities
     * @param int $attributesCount
     * @param RequestModel $requestModel
     */
    public function init($attributeEntities, $attributesCount, RequestModel $requestModel)
    {
        //ok first set the db entity
        $this->attributeEntities = $attributeEntities;
        $this->attributesCount = $attributesCount;
        $this->requestModel = $requestModel;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributeEntities ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributeEntities ? false : 'attributeEntity data not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->attributeEntities) {

            $this->apiM->responseBuilder()->addCount($this->attributesCount);
            if ($this->requestModel->getOffset() !== null) {
                $this->apiM->responseBuilder()->addOffset($this->requestModel->getOffset());
            }
            if ($this->requestModel->getLimit() !== null) {
                $this->apiM->responseBuilder()->addLimit($this->requestModel->getLimit());
            }

            $document = $this->apiM->responseBuilder()->document();
            foreach ($this->attributeEntities as $attribute) {

                $responseAttribute = new ResponseAttribute();
                $responseAttribute
                    ->setId($attribute->getId())
                    ->setName($attribute->getName())
                    ->setMandatory($attribute->getMandatory())
                    ->setPossibleValues($attribute->getPossibleValues())
                    ->setDefaultValue($attribute->getDefaultValue())
                    ->setTranslatable($attribute->getTranslatable());

                $docFragment = $document->createDocumentFragment();
                $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '',
                    $this->apiM->serializer()->serialize($responseAttribute, 'xml')));
                $xmlContainer->appendChild($docFragment);
            }
        } else {
            $this->apiM->errors()->clearErrors();
            $this->apiM->errors()->addError(
                new ExternalError(
                    'as001',
                    'No attributes found.',
                    'No attributes found.',
                    'No attributes found for given id.'
                )
            );
        }
    }
}
