<?php

/**
 * Class AttributeGroup
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("AttributeGroupType")
 * @Serializer\ExclusionPolicy("all")
 *
 * @package Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity
 */
class AttributeGroup
{
    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\Expose
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Types")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity\Type>")
     * @Serializer\XmlList(entry="Id")
     */
    private $type;

    /**
     * @Serializer\Expose
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("Count")
     *
     * @var int
     */
    private $count;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("Attributes")
     * @Serializer\Type("ArrayCollection<Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity\Attribute>")
     * @Serializer\XmlList(entry="Attribute")
     */
    private $attributes;

    public function __construct()
    {
        $this->type = new ArrayCollection();
        $this->attributes = new ArrayCollection();
    }

    /**
     * Set id
     *
     * @param string $id
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Get name
     *
     * @param string $name
     * @return string
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get name
     *
     * @return Type[]
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param Type $type
     * @return AttributeGroup
     */
    public function addType(Type $type)
    {
        $this->type[] = $type;

        return $this;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     * @return AttributeGroup
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }

    /**
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Attribute $attribute
     * @return AttributeGroup
     */
    public function addAttribute($attribute)
    {
        $this->attributes[] = $attribute;

        return $this;
    }

}
