<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show;

use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Base as AttributeGroupBase;
use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity\Attribute as ResponseAttribute;
use Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show\Entity\AttributeGroup as ResponseObject;
use Sso\Webservices\ObjectBundle\Entity\AttributeGroup as EntityAttributeGroup;
use Sso\Webservices\ObjectBundle\Model\Request\AttributeGroup\Show\Entity\AttributeGroup as RequestModel;
use LifeStyle\Tools\WebserviceBundle\Error\Type\External as ExternalError;

/**
 * Class Show
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\AttributeGroup\Show
 */
class Show extends AttributeGroupBase
{

    /**
     *
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var EntityAttributeGroup[]
     */
    protected $attributeGroupEntities;

    /**
     * @var int
     */
    protected $attributeGroupsCount;

    /**
     * @var RequestModel
     */
    private $requestModel;

    /**
     *
     * @param EntityAttributeGroup[] $attrGroupEntities
     * @param int $attributeGroupsCount
     * @param RequestModel $requestModel
     */
    public function init($attrGroupEntities, $attributeGroupsCount, RequestModel $requestModel)
    {
        //ok first set the db entity
        $this->attributeGroupEntities = $attrGroupEntities;
        $this->attributeGroupsCount = $attributeGroupsCount;
        $this->requestModel = $requestModel;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->attributeGroupEntities ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attributeGroupEntities ? false : 'attributeGroupEntity data not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->attributeGroupEntities) {

            $this->apiM->responseBuilder()->addCount($this->attributeGroupsCount);
            if ($this->requestModel->getOffset() !== null) {
                $this->apiM->responseBuilder()->addOffset($this->requestModel->getOffset());
            }
            if ($this->requestModel->getLimit() !== null) {
                $this->apiM->responseBuilder()->addLimit($this->requestModel->getLimit());
            }

            $document = $this->apiM->responseBuilder()->document();
            foreach ($this->attributeGroupEntities as $attributeGroup) {
                $modelOut = $this->apiM->mapper()->modelInToModelOut($attributeGroup, new ResponseObject());
                $modelOut->setCount(count($attributeGroup->getAttributes()));

                foreach ($attributeGroup->getAttributes() as $attribute) {
                    $attributeOut = $this->apiM->mapper()->modelInToModelOut($attribute, new ResponseAttribute());
                    $modelOut->addAttribute($attributeOut);
                }

                $docFragment = $document->createDocumentFragment();
                $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '',
                    $this->apiM->serializer()->serialize($modelOut, 'xml')));
                $xmlContainer->appendChild($docFragment);
            }
        } else {
            $this->apiM->errors()->clearErrors();
            $this->apiM->errors()->addError(new ExternalError('ags001', 'No attribute groups found.',
                'No attribute groups found.', 'No attribute groups found for given id.'));
        }
    }

}
