<?php

/**
 *
 * @class Base
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Response;

use Sso\Webservices\ObjectBundle\Model\Request\Base as RequestBase;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\ApiBundle\Database\Manager as DatabaseManager;

/**
 * Base class for response
 */
abstract class Base
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Db Manager
     *
     * @var DatabaseManager
     */
    protected $dbM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->dbM = $this->apiM->database();
    }

    /**
     * Returns response message e. g. Application added
     *
     * @return string|bool Set to false, to suppress message element
     */
    abstract protected function getResponseMessage();

    /**
     * Returns response true, false or Success, Failure
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return true;
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        if (false !== ($message = $this->getResponseMessage())) {
            $xmlContainer->appendChild($this->apiM->responseBuilder()->document()->createTextElement('Message',
                $message));
        }
    }

    /**
     * Generate xml response
     *
     * @param RequestBase $requestModel
     */
    protected function buildResponse()
    {
        $action = $this->apiM->responseBuilder()->action();
        $this->apiM->responseBuilder()->status($this->getResponseStatus());
        $this->buildResponseBody($action);
        $this->apiM->responseBuilder()->endAction();
    }

}
