<?php

/**
 *
 * @class Factory
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Response;

use Sso\Webservices\ObjectBundle\Model\Response;
use Sso\ApiBundle\Api\Manager as ApiManager;

/**
 * Response factory class
 */
class Factory
{

    /**
     * List of factories
     *
     * @var array
     */
    protected $factories;

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return Type\Factory
     */
    public function type()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Type\Factory');
    }

    /**
     * @return Object\Factory
     */
    public function object()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Object\Factory');
    }

    /**
     * @return ObjectValue\Factory
     */
    public function objectValue()
    {
        return $this->_getFactory(__NAMESPACE__ . '\ObjectValue\Factory');
    }

    /**
     * @return Response\Language\Factory
     */
    public function language()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Language\Factory');
    }

    /**
     * @return Response\Country\Factory
     */
    public function country()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Country\Factory');
    }

    /**
     * @return Response\AttributeGroup\Factory
     */
    public function attributeGroup()
    {
        return $this->_getFactory(__NAMESPACE__ . '\AttributeGroup\Factory');
    }

    /**
     * @return Response\Attribute\Factory
     */
    public function attribute()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Attribute\Factory');
    }

    /**
     * Returns factory
     *
     * @param string $class
     * @return
     */
    protected function _getFactory($class)
    {
        return isset($this->factories[$class]) ? $this->factories[$class] : ($this->factories[$class] = new $class($this->apiM));
    }

}
