<?php

/**
 * Response object factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\Object;

use Sso\Webservices\ObjectBundle\Model\Response\Object\Add;
use Sso\Webservices\ObjectBundle\Model\Response\Object\Show;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Sso\Webservices\ObjectBundle\Entity\Object as EntityObject;

/**
 * Response object factory
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Factory
{
    /**
     * Api Manager
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * @var array
     */
    private $facSetter;

    /**
     * Constructor
     *
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param EntityObject $requestModel
     */
    public function add(EntityObject $requestModel)
    {
        $model = new Add\Add($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @return ShowSingle\Factory
     */
    public function showSingle()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ShowSingle\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ShowMulti\Factory
     */
    public function showMulti()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ShowMulti\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return TreeView\Factory
     */
    public function treeView()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new TreeView\Factory($this->apiM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @param EntityObject $requestModel
     */
    public function update(EntityObject $requestModel)
    {
        $model = new Update\Update($this->apiM);
        $model->init($requestModel);
        $model->createResponse();
    }

    /**
     * @param EntityObject $objectEntity
     */
    public function delete(EntityObject $objectEntity)
    {
        $model = new Delete\Delete($this->apiM);
        $model->init($objectEntity);
        $model->createResponse();
    }

}
