<?php

/**
 * @class Add
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Add;

use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Base as ObjectBase;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Add\Entity\ObjectValue as ResponseModel;

class Add extends ObjectBase
{
    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     * @var ObjectAttributeValue
     */
    protected $objectAttributeValue;

    /**
     * @param ObjectAttributeValue $objectAttributeValue
     */
    public function init(ObjectAttributeValue $objectAttributeValue)
    {
        //ok first set the db entity
        $this->objectAttributeValue = $objectAttributeValue;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->objectAttributeValue ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->objectAttributeValue ? false : 'ObjectValue data not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;
        if ($this->objectAttributeValue) {
            $modelOut = $this->customMapModel();

            $document = $this->apiM->responseBuilder()->document();
            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '',
                $this->apiM->serializer()->serialize($modelOut, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

    /**
     * @return ResponseModel
     */
    protected function customMapModel()
    {
        $modelOut = new ResponseModel();
        $modelOut
            ->setObjectGuid($this->objectAttributeValue->getObject()->getGuid())
            ->setObjectName($this->objectAttributeValue->getObject()->getName())
            ->setAttributeName($this->objectAttributeValue->getAttribute()->getName())
            ->setAttributeId($this->objectAttributeValue->getAttribute()->getId())
            ->setId($this->objectAttributeValue->getId())
            ->setValue($this->objectAttributeValue->getValue())
            ->setLanguageCode($this->objectAttributeValue->getLanguage()->getId())
            ->setCreated($this->objectAttributeValue->getCreated())
            ->setUpdated($this->objectAttributeValue->getUpdated());

        return $modelOut;
    }
}
