<?php

/**
 * Class Update
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update;

use Sso\Webservices\ObjectBundle\Model\Response\Type\Base as TypeBase;
use Sso\Webservices\ObjectBundle\Entity\ObjectAttributeValue as ObjectAttributeValueEntity;
use Sso\Webservices\ObjectBundle\Model\Request\ObjectValue\Update\Entity as RequestEntity;
use Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update\Entity as ResponseObjectValue;

/**
 * Class Update
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Model\Response\ObjectValue\Update
 */
class Update extends TypeBase
{

    /**
     * @var \DOMElement
     */
    protected $xmlContainer;

    /**
     *
     * @var ObjectAttributeValueEntity
     */
    protected $objectValueEntity;

    /**
     *
     * @var RequestEntity
     */
    protected $helperModel;

    /**
     *
     * @param ObjectAttributeValueEntity $objectValueEntity
     * @param RequestEntity $helperModel
     */
    public function init($objectValueEntity, $helperModel)
    {
        //ok first set the db entity
        $this->objectValueEntity = $objectValueEntity;
        $this->helperModel = $helperModel;
    }

    /**
     * Returns response status
     *
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->objectValueEntity ? 'Success' : 'Failure';
    }

    /**
     * Returns response message
     *
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->objectValueEntity ? false : 'ObjectValue not found';
    }

    /**
     * Build response body
     *
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        $this->xmlContainer = $xmlContainer;

        if ($this->objectValueEntity) {

            $document = $this->apiM->responseBuilder()->document();

            /**
             * @var ResponseObjectValue $modelOut
             */
            $modelOut = $this->apiM->mapper()->modelInToModelOut($this->objectValueEntity, new ResponseObjectValue());
            $modelOut->setLanguageCode($this->objectValueEntity->getLanguage()->getId());

            $docFragment = $document->createDocumentFragment();
            $docFragment->appendXML(preg_replace('/^\<?[^\>]*\>\s*/', '',
                $this->apiM->serializer()->serialize($modelOut, 'xml')));

            $xmlContainer->appendChild($docFragment);
        }
    }

}
