<?php

/**
 * Class AttributeControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Doctrine\Common\DataFixtures\Executor\ORMExecutor;
use Doctrine\Common\DataFixtures\Loader;
use Doctrine\Common\DataFixtures\Purger\ORMPurger;
use Guzzle\Service\Client;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServiceNames2Services;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadServices;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens;
use LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM\LoadTokens2ServiceNames;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Sso\ApiBundle\Api\Manager as ApiManager;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class AttributeControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class AttributeControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerAttributeShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '0c7d874e-a114-bf02-81d4-ec7935c748ca' => 'UnitTestAttributeOne',
            '229b72ca-1927-68b2-5aeb-e87c74af717e' => 'UnitTestAttributeTwo',
        ];

        foreach ($responseXml->Unknown->Unknown->AttributeType as $attribute) {
            $this->assertTrue(isset($expectedBag[(string)$attribute->Id]));
            $this->assertEquals($expectedBag[(string)$attribute->Id], $attribute->Name);
        }

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeShowWithOffsetAndLimitSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                        <Offset>1</Offset>
                                        <Limit>1</Limit>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $expectedBag = [
            '229b72ca-1927-68b2-5aeb-e87c74af717e' => 'UnitTestAttributeTwo',
        ];

        $this->assertSame(1, count($responseXml->Unknown->Unknown->AttributeType));

        $attribute = $responseXml->Unknown->Unknown->AttributeType[0];
        $this->assertTrue(isset($expectedBag[(string)$attribute->Id]));
        $this->assertEquals($expectedBag[(string)$attribute->Id], $attribute->Name);

        $this->assertEquals('Success', $responseXml->Status);
    }

    public function testWorkerAttributeShowByIdSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Show>
                                    <AttributeType>
                                        <Id>0c7d874e-a114-bf02-81d4-ec7935c748ca</Id>
                                    </AttributeType>
                                </Show>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->show($xml->Attribute->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('0c7d874e-a114-bf02-81d4-ec7935c748ca', $responseXml->Unknown->Unknown->AttributeType->Id);
        $this->assertEquals('UnitTestAttributeOne', $responseXml->Unknown->Unknown->AttributeType->Name);
    }

    public function testWorkerAttributeUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Update>
                                    <AttributeType>
                                        <Id>229b72ca-1927-68b2-5aeb-e87c74af717e</Id>
                                        <Name>UnitTestAttributeTwoUpdated</Name>
                                        <GroupId>b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e</GroupId>
                                    </AttributeType>
                                </Update>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->update($xml->Attribute->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('229b72ca-1927-68b2-5aeb-e87c74af717e', $responseXml->Unknown->Unknown->AttributeType->Id);
        $this->assertEquals('UnitTestAttributeTwoUpdated', $responseXml->Unknown->Unknown->AttributeType->Name);
        $this->assertEquals('b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e',
            $responseXml->Unknown->Unknown->AttributeType->GroupId);
    }

    public function testWorkerAttributeAddSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Add>
                                    <AttributeType>
                                        <Name>UnitTestAttributeAdd</Name>
                                        <GroupId>b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e</GroupId>
                                    </AttributeType>
                                </Add>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->add($xml->Attribute->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals(36, strlen($responseXml->Unknown->Unknown->AttributeType->Id));
        $this->assertEquals('UnitTestAttributeAdd', $responseXml->Unknown->Unknown->AttributeType->Name);
        $this->assertEquals('b3ab16cb-8e3d-36d7-33a6-b59a7cd7c49e',
            $responseXml->Unknown->Unknown->AttributeType->GroupId);
    }

    public function testWorkerAttributeDeleteSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Attribute>
                                <Delete>
                                    <AttributeType>
                                        <Id>229b72ca-1927-68b2-5aeb-e87c74af717e</Id>
                                    </AttributeType>
                                </Delete>
                            </Attribute>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->attribute()->delete($xml->Attribute->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('229b72ca-1927-68b2-5aeb-e87c74af717e', $responseXml->Unknown->Unknown->AttributeType->Id);
    }

}
