<?php

/**
 * Class TypeControllerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Webservices\ObjectBundle\Tests\Controller;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class TypeControllerTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\Webservices\ObjectBundle\Tests\Controller
 */
class TypeControllerTest extends ControllerTestCase
{

    /**
     * @var WorkerFactory
     */
    protected $worker;

    protected function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');

        $this->worker = new WorkerFactory($this->apiM());
    }

    public function testWorkerTypeShowAllSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Show>
                                    <TypeType>
                                    </TypeType>
                                </Show>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->show($xml->Type->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);

        $expectedBag = [];
        $expectedTypes = $this->worker->objectDbM()->respository()->type()->findAll();

        foreach ($expectedTypes as $expectedType) {
            $expectedBag[$expectedType->getId()] = $expectedType->getName();
        }

        foreach ($responseXml->Unknown->Unknown->TypeType as $type) {
            $this->assertTrue(isset($expectedBag[(string)$type->Id]));
            $this->assertEquals($expectedBag[(string)$type->Id], $type->Name);
        }

    }

    public function testWorkerTypeShowByGuidSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Show>
                                    <TypeType>
                                        <Id>bb25734e-bff8-878a-e4f7-b2f0f38142f7</Id>
                                    </TypeType>
                                </Show>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->show($xml->Type->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('bb25734e-bff8-878a-e4f7-b2f0f38142f7', $responseXml->Unknown->Unknown->TypeType->Id);
        $this->assertEquals('UnitTestType1', $responseXml->Unknown->Unknown->TypeType->Name);
    }

    public function testWorkerTypeShowByNameSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Show>
                                    <TypeType>
                                        <Name>UnitTestType2</Name>
                                    </TypeType>
                                </Show>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->show($xml->Type->Show);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('e43752bb-e4f7-878a-bff8-b2f0f38142f7', $responseXml->Unknown->Unknown->TypeType->Id);
        $this->assertEquals('UnitTestType2', $responseXml->Unknown->Unknown->TypeType->Name);
    }

    public function testWorkerTypeUpdateSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Update>
                                    <TypeType>
                                        <Id>e43752bb-e4f7-878a-bff8-b2f0f38142f7</Id>
                                        <Name>UnitTestType2Updated</Name>
                                        <TypeOrder>7</TypeOrder>
                                    </TypeType>
                                </Update>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->update($xml->Type->Update);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('e43752bb-e4f7-878a-bff8-b2f0f38142f7', $responseXml->Unknown->Unknown->TypeType->Id);
        $this->assertEquals('UnitTestType2Updated', $responseXml->Unknown->Unknown->TypeType->Name);
        $this->assertEquals('7', $responseXml->Unknown->Unknown->TypeType->TypeOrder);
    }

    public function testWorkerTypeAddSuccess()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Add>
                                    <TypeType>
                                        <Name>UnitTestAddNewTypeName</Name>
                                        <TypeOrder>100</TypeOrder>
                                    </TypeType>
                                </Add>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->add($xml->Type->Add);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());

        $this->assertEquals('Success', $responseXml->Status);
        $this->assertEquals('UnitTestAddNewTypeName', $responseXml->Unknown->Unknown->TypeType->Name);
        $this->assertEquals('100', $responseXml->Unknown->Unknown->TypeType->TypeOrder);
    }

    public function testWorkerTypeDeleteFailure()
    {
        $xmlString = '<?xml version="1.0"?>
                        <SsoRequest>
                            <Type>
                                <Delete>
                                    <TypeType>
                                        <Id>e43752bb-e4f7-878a-bff8-b2f0f38142f7</Id>
                                    </TypeType>
                                </Delete>
                            </Type>
                      </SsoRequest>';

        $xml = simplexml_load_string($xmlString);
        $this->worker->type()->delete($xml->Type->Delete);

        $responseXml = simplexml_load_string($this->apiM()->responseBuilder()->output());
        $this->assertEquals('Failure', $responseXml->Status);
    }
}
