<?php

/**
 *
 * @class Index
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 *
 */

namespace Sso\Webservices\ObjectBundle\Worker\AttributeGroup;

use Sso\Webservices\ObjectBundle\Worker\Factory as WorkerFactory;
use LifeStyle\Tools\WebserviceBundle\Exception\InvalidRecordException;
use Sso\ApiBundle\Api\Manager as ApiManager;

class Index
{

    /**
     * Api Manager
     *
     * @var ApiManager
     */
    private $apiM;

    /**
     *
     * @var WorkerManager
     */
    private $woM;

    /**
     * Constructor
     *
     * @param WorkerFactory $woM
     */
    public function __construct(WorkerFactory $woM)
    {
        $this->woM = $woM;
        $this->apiM = $this->woM->apiM();
    }

    /**
     * show object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function show(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeShowRequest = $this->woM->modelFactory()->request()->attributeGroup()->show($xml);
            $this->woM->modelFactory()->response()->attributeGroup()->show($attributeShowRequest->getAttributeGroupModels(),
                $attributeShowRequest->getAttributeGroupsCount(), $attributeShowRequest->getRequestModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * add object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function add(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeAddRequest = $this->woM->modelFactory()->request()->attributeGroup()->add($xml);
            $this->woM->modelFactory()->response()->attributeGroup()->add($attributeAddRequest->getAttributeGroupModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * add object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function update(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeGroupUpdateRequest = $this->woM->modelFactory()->request()->attributeGroup()->update($xml);
            $this->woM->modelFactory()->response()->attributeGroup()->update($attributeGroupUpdateRequest->getAttributeGroupModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

    /**
     * delete object
     *
     * @param \SimpleXMLElement $xml Record
     */
    public function delete(\SimpleXMLElement $xml)
    {
        $this->apiM->errors()->clearErrors();
        try {
            $attributeGroupDeleteRequest = $this->woM->modelFactory()->request()->attributeGroup()->delete($xml);
            $this->woM->modelFactory()->response()->attributeGroup()->delete($attributeGroupDeleteRequest->getAttributeGroupModel());
        } catch (InvalidRecordException $e) {
            // Catch invalid record contents only
            $this->apiM->responseBuilder()->endAction();
        }
    }

}