<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Initialize tables for backend database
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Application\Migrations
 */
class Version20160607212249 extends AbstractMigration implements ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE backend_session (session_id VARCHAR(255) NOT NULL, session_value BLOB NOT NULL, session_time INT NOT NULL, session_lifetime BIGINT NOT NULL, PRIMARY KEY(session_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE backend_user (id INT AUTO_INCREMENT NOT NULL, username VARCHAR(255) NOT NULL, username_canonical VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, email_canonical VARCHAR(255) NOT NULL, enabled TINYINT(1) NOT NULL, salt VARCHAR(255) NOT NULL, password VARCHAR(255) NOT NULL, last_login DATETIME DEFAULT NULL, locked TINYINT(1) NOT NULL, expired TINYINT(1) NOT NULL, expires_at DATETIME DEFAULT NULL, confirmation_token VARCHAR(255) DEFAULT NULL, password_requested_at DATETIME DEFAULT NULL, roles LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', credentials_expired TINYINT(1) NOT NULL, credentials_expire_at DATETIME DEFAULT NULL, firstname VARCHAR(127) DEFAULT NULL, lastname VARCHAR(127) DEFAULT NULL, organisation VARCHAR(127) DEFAULT NULL, UNIQUE INDEX UNIQ_C73586E92FC23A8 (username_canonical), UNIQUE INDEX UNIQ_C73586EA0D96FBF (email_canonical), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE system_log (id VARCHAR(64) NOT NULL, level INT DEFAULT NULL, channel VARCHAR(32) DEFAULT NULL, extras VARCHAR(32) DEFAULT NULL, modified DATETIME NOT NULL, created DATETIME NOT NULL, createdTime BIGINT UNSIGNED NOT NULL, INDEX idx_level (level, createdTime, created, modified, extras, channel), INDEX idx_channel (channel, createdTime, created, modified, extras, level), INDEX idx_extras (extras, createdTime, created, modified, channel, level), INDEX idx_createdTime (createdTime, created, modified, extras, channel, level), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE system_log_data (id VARCHAR(64) NOT NULL, log LONGTEXT DEFAULT NULL, serverData LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_D577AC94BF396750 (id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE objects_import_config (id INT AUTO_INCREMENT NOT NULL, column_name VARCHAR(255) NOT NULL, object_value_id VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE system_log_data ADD CONSTRAINT FK_D577AC94BF396750 FOREIGN KEY (id) REFERENCES system_log (id) ON DELETE CASCADE');
    }

    /**
     * Create admin user
     *
     * @param Schema $schema
     */
    public function postUp(Schema $schema)
    {
        /** @var \FOS\UserBundle\Doctrine\UserManager $userManager */
        $userManager = $this->container->get('fos_user.user_manager');
        $user = $userManager->createUser();
        $user->setUsername('admin');
        $user->setEmail('info@life-style.de');
        $user->setPlainPassword('test#1010');
        $user->addRole('ROLE_SUPER_ADMIN');
        $user->setEnabled(true);
        $userManager->updateUser($user);
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE system_log_data DROP FOREIGN KEY FK_D577AC94BF396750');
        $this->addSql('DROP TABLE backend_session');
        $this->addSql('DROP TABLE backend_user');
        $this->addSql('DROP TABLE system_log');
        $this->addSql('DROP TABLE system_log_data');
        $this->addSql('DROP TABLE objects_import_config');
    }

    /**
     * Sets the container.
     *
     * @param ContainerInterface|null $container A ContainerInterface instance or null
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * @return string
     */
    private function getConfiguredDatabaseName()
    {
        return $this->container->getParameter('database_backend_name');
    }
}
