<?php

namespace Application\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Initialize tables for service-provider database
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Application\Migrations
 */
class Version20160607213013 extends AbstractMigration implements ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE wssp_services (ServiceId INT AUTO_INCREMENT NOT NULL, ServiceType VARCHAR(100) NOT NULL, ServiceController VARCHAR(100) NOT NULL, ServiceAction VARCHAR(100) NOT NULL, ServiceMapped2Group VARCHAR(100) NOT NULL, PRIMARY KEY(ServiceId)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE wssp_servicenames (ServiceNameId INT AUTO_INCREMENT NOT NULL, ServiceName VARCHAR(255) NOT NULL, ServiceActive SMALLINT NOT NULL, PRIMARY KEY(ServiceNameId)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE wssp_servicename2services (ServiceNameId INT NOT NULL, ServiceId INT NOT NULL, INDEX IDX_9B97AD8C5CC2A9D4 (ServiceNameId), INDEX IDX_9B97AD8CB98FD0B (ServiceId), PRIMARY KEY(ServiceNameId, ServiceId)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE wssp_tokens (ServiceToken VARCHAR(255) NOT NULL, ServiceToken2Ip VARCHAR(255) NOT NULL, AllowedCallsPerDay INT NOT NULL, ValidUntil DATE NOT NULL, Blocked SMALLINT NOT NULL, BlockedReason VARCHAR(255) DEFAULT NULL, Description VARCHAR(255) NOT NULL, PRIMARY KEY(ServiceToken)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE wssp_token2servicename (ServiceToken VARCHAR(255) NOT NULL, ServiceNameId INT NOT NULL, INDEX IDX_6DCA695D15A19130 (ServiceToken), INDEX IDX_6DCA695D5CC2A9D4 (ServiceNameId), PRIMARY KEY(ServiceToken, ServiceNameId)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE wssp_tokenusage (UsageId VARCHAR(64) NOT NULL, ServiceToken VARCHAR(255) NOT NULL, Date DATETIME NOT NULL, Ip VARCHAR(64) DEFAULT NULL, Controller VARCHAR(32) DEFAULT NULL, Action VARCHAR(32) DEFAULT NULL, TrackId VARCHAR(10) DEFAULT NULL, Status VARCHAR(10) DEFAULT NULL, INDEX IDX_18F28BEC15A19130 (ServiceToken), INDEX idx_token (ServiceToken, Date, Controller, Action), INDEX idx_date (Date), PRIMARY KEY(UsageId)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE wssp_servicename2services ADD CONSTRAINT FK_9B97AD8C5CC2A9D4 FOREIGN KEY (ServiceNameId) REFERENCES wssp_servicenames (ServiceNameId)');
        $this->addSql('ALTER TABLE wssp_servicename2services ADD CONSTRAINT FK_9B97AD8CB98FD0B FOREIGN KEY (ServiceId) REFERENCES wssp_services (ServiceId)');
        $this->addSql('ALTER TABLE wssp_token2servicename ADD CONSTRAINT FK_6DCA695D15A19130 FOREIGN KEY (ServiceToken) REFERENCES wssp_tokens (ServiceToken)');
        $this->addSql('ALTER TABLE wssp_token2servicename ADD CONSTRAINT FK_6DCA695D5CC2A9D4 FOREIGN KEY (ServiceNameId) REFERENCES wssp_servicenames (ServiceNameId)');
        $this->addSql('ALTER TABLE wssp_tokenusage ADD CONSTRAINT FK_18F28BEC15A19130 FOREIGN KEY (ServiceToken) REFERENCES wssp_tokens (ServiceToken)');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->skipIf($this->connection->getDatabase() !== $this->getConfiguredDatabaseName(), 'Skipped migration. Database does not match.');

        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE wssp_servicename2services DROP FOREIGN KEY FK_9B97AD8CB98FD0B');
        $this->addSql('ALTER TABLE wssp_servicename2services DROP FOREIGN KEY FK_9B97AD8C5CC2A9D4');
        $this->addSql('ALTER TABLE wssp_token2servicename DROP FOREIGN KEY FK_6DCA695D5CC2A9D4');
        $this->addSql('ALTER TABLE wssp_token2servicename DROP FOREIGN KEY FK_6DCA695D15A19130');
        $this->addSql('ALTER TABLE wssp_tokenusage DROP FOREIGN KEY FK_18F28BEC15A19130');
        $this->addSql('DROP TABLE wssp_services');
        $this->addSql('DROP TABLE wssp_servicenames');
        $this->addSql('DROP TABLE wssp_servicename2services');
        $this->addSql('DROP TABLE wssp_tokens');
        $this->addSql('DROP TABLE wssp_token2servicename');
        $this->addSql('DROP TABLE wssp_tokenusage');
    }

    /**
     * Sets the container.
     *
     * @param ContainerInterface|null $container A ContainerInterface instance or null
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * @return string
     */
    private function getConfiguredDatabaseName()
    {
        return $this->container->getParameter('database_sp_name');
    }
}
