<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle;

/**
 * Interface ActivityLogHandlerInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    LifeStyle\ActivityLogBundle
 */
interface ActivityLogHandlerInterface
{
    /**
     * @param $controller
     * @param $action
     * @param $type
     * @param string|null $request
     * @param string|null $response
     * @param array $stats
     * @return mixed
     */
    public function log($controller, $action, $type, $request = null, $response = null, $stats = []);
}
