<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle\Filter;

/**
 * Class TextFilter
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    LifeStyle\ActivityLogBundle\Filter
 */
class TextFilter
{
    /**
     * @var TextFilterConfiguration
     */
    private $configuration;

    /**
     * TextFilter constructor.
     * @param TextFilterConfiguration $configuration
     */
    public function __construct(TextFilterConfiguration $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @param string $text
     * @return string
     */
    public function filter($text)
    {
        $search = $this->configuration->getSearch();
        if (0 === count($search)) {
            return $text;
        }

        $replace = $this->configuration->getReplace();
        $text = str_replace($search, $replace, $text);

        $search = $this->urlencode($search);
        $text = str_replace($search, $replace, $text);

        return $text;
    }

    /**
     * @param array $values
     * @return array
     */
    private function urlencode(array $values)
    {
        array_walk($values, function(&$value) {
            $value = urlencode($value);
        });
        return $values;
    }
}
