<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle\Filter;

/**
 * Class TextFilterConfiguration
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    LifeStyle\ActivityLogBundle\Filter
 */
class TextFilterConfiguration
{
    /**
     * @var array
     */
    private $search = [];

    /**
     * @var array
     */
    private $replace = [];

    /**
     * @param string $search
     * @param string $replace
     */
    public function addFilter($search, $replace)
    {
        $this->search[] = $search;
        $this->replace[] = $replace;
    }

    /**
     * @return array
     */
    public function getSearch()
    {
        return $this->search;
    }

    /**
     * @return array
     */
    public function getReplace()
    {
        return $this->replace;
    }
}
