<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\ActivityLogBundle\Tests\Entity;

use LifeStyle\ActivityLogBundle\Entity\UserActionLog;
use LifeStyle\ActivityLogBundle\Entity\UserActionLogData;
use LifeStyle\SamlAuthBundle\Entity\User;
use PHPUnit_Framework_TestCase;

/**
 * Class UserActionLogTest
 * @package LifeStyle\ActivityLogBundle\Tests\Entity
 */
class UserActionLogTest extends PHPUnit_Framework_TestCase
{
    const TESTDATA_IAMAREQUEST = '<IAmARequest/>';
    const TESTDATA_IAMARESPONSE = '<IAmAResponse/>';

    public function testEntityUser()
    {
        $user = new User();

        $logData = new UserActionLogData();
        $logData->setRequest(static::TESTDATA_IAMAREQUEST);
        $logData->setResponse(static::TESTDATA_IAMARESPONSE);
        $this->assertNull($logData->getKeyId());

        $actionLog = new UserActionLog();
        $actionLog
            ->setController('controller')
            ->setUser($user)
            ->setAction('action')
            ->setLocalUserId('1337')
            ->setType('type')
            ->setIpAddress('127.0.0.1')
            ->setUserActionLogData($logData);

        $this->assertEquals('controller', $actionLog->getController());
        $this->assertEquals('action', $actionLog->getAction());
        $this->assertNotEmpty($actionLog->getKeyId());
        $this->assertEquals('1337', $actionLog->getLocalUserId());
        $this->assertEquals('type', $actionLog->getType());
        $this->assertEquals('127.0.0.1', $actionLog->getIpAddress());
        $this->assertInstanceOf(\DateTime::class, $actionLog->getCreatedAt());
        $this->assertInstanceOf(User::class, $actionLog->getUser());

        $this->assertEquals(static::TESTDATA_IAMAREQUEST, $actionLog->getUserActionLogData()->getRequest());
        $this->assertEquals(static::TESTDATA_IAMARESPONSE, $actionLog->getUserActionLogData()->getResponse());
        $this->assertEquals(static::TESTDATA_IAMAREQUEST, $actionLog->getRequest());
        $this->assertEquals(static::TESTDATA_IAMARESPONSE, $actionLog->getResponse());

        $logData->setUserActionLog($actionLog);
        $this->assertEquals($actionLog->getKeyId(), $logData->getUserActionLog()->getKeyId());
    }
}
