<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Database\Data;

use LifeStyle\SamlAuthBundle\Database\Manager as DbManger;

/**
 * Class Factory
 * @package LifeStyle\SamlAuthBundle\Database\Data
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @var DbManger
     */
    private $dbM;

    /**
     * Factory constructor.
     * @param DbManger $dbM
     */
    public function __construct(DbManger $dbM)
    {
        $this->dbM = $dbM;
    }

    /**
     * @return User\Index
     */
    public function user()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new User\Index($this->dbM);
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserLoginHistory\Index
     */
    public function userLoginHistory()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserLoginHistory\Index($this->dbM);
        }

        return $this->facSetter[__FUNCTION__];
    }
}
