<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Database;

use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;

/**
 * Class Manager
 * @package LifeStyle\SamlAuthBundle\Database
 */
class Manager
{
    const EM_CONNECTION_NAME = "Backend";

    /**
     * @var array
     */
    private $manSetter;

    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    /**
     * @var EntityManager
     */
    private $entityManager;


    /**
     * Manager constructor.
     * @param DoctrineRegistry $doctrineRegistry
     */
    public function __construct(DoctrineRegistry $doctrineRegistry)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->entityManager = $this->doctrineRegistry->getManager(static::EM_CONNECTION_NAME);
    }

    /**
     * @return EntityManager
     */
    public function getEntityManager()
    {
        return $this->entityManager;
    }

    /**
     * @return DoctrineRegistry
     */
    public function getDoctrineRegistry()
    {
        return $this->doctrineRegistry;
    }

    /**
     * @return Entity\Factory
     */
    public function entity()
    {
        if (!isset($this->manSetter[__FUNCTION__])) {
            $this->manSetter[__FUNCTION__] = new Entity\Factory();
        }

        return $this->manSetter[__FUNCTION__];
    }

    /**
     * @return Repository\Factory
     */
    public function repository()
    {
        if (!isset($this->manSetter[__FUNCTION__])) {
            $this->manSetter[__FUNCTION__] = new Repository\Factory($this->doctrineRegistry);
        }

        return $this->manSetter[__FUNCTION__];
    }

    /**
     * @return Data\Factory
     */
    public function data()
    {
        if (!isset($this->manSetter[__FUNCTION__])) {
            $this->manSetter[__FUNCTION__] = new Data\Factory($this);
        }

        return $this->manSetter[__FUNCTION__];
    }
}
