<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class UserLoginHistory
 * @package LifeStyle\SamlAuthBundle\Entity
 *
 * @ORM\Table(name="saml_user_history")
 * @ORM\Entity
 */
class UserLoginHistory
{
    /**
     * @ORM\Column(type="guid", name="id")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="UUID")
     * @var string
     */
    private $keyId;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="userLoginHistory")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="local_user_id", referencedColumnName="id")
     * })
     * @var User
     */
    private $user;

    /**
     * @ORM\Column(name="local_user_id", type="guid", nullable=false)
     * @var string
     */
    private $localUserId;

    /**
     * @ORM\Column(name="user_identifier", type="string", nullable=false)
     * @var string
     */
    private $userIdentifier;

    /**
     * @ORM\Column(name="last_login_at", type="datetime", nullable=false)
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->keyId;
    }

    /**
     * @return string
     */
    public function getLocalUserId()
    {
        return $this->localUserId;
    }

    /**
     * @param string $localUserId
     * @return UserLoginHistory
     */
    public function setLocalUserId($localUserId)
    {
        $this->localUserId = $localUserId;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserLoginHistory
     */
    public function setLastLoginAt(\DateTime $lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;

        return $this;
    }

    /**
     * @param User $user
     * @return UserLoginHistory
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @param string $userId
     * @return UserLoginHistory
     */
    public function setUserIdentifier($userId)
    {
        $this->userIdentifier = $userId;

        return $this;
    }
}
