<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Model\UserData;

/**
 * Class ServiceUserType
 * @package LifeStyle\SamlAuthBundle\Model\UserData
 */
class ServiceUserType
{
    /**
     * @var boolean
     */
    private $used;
    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $identifier;

    /**
     * @var \DateTime
     */
    private $expire;

    /**
     * ServiceUserType constructor.
     */
    public function __construct()
    {
        $this->used = false;
    }

    /**
     * @return boolean
     */
    public function isUsed()
    {
        return $this->used;
    }

    /**
     * @param boolean $used
     * @return ServiceUserType
     */
    public function setUsed($used)
    {
        $this->used = $used;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return ServiceUserType
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return ServiceUserType
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpire()
    {
        return $this->expire;
    }

    /**
     * @param \DateTime $expire
     * @return ServiceUserType
     */
    public function setExpire($expire)
    {
        $this->expire = $expire;
        return $this;
    }
}
