<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Configuration;

use LifeStyle\SamlAuthBundle\Configuration\SamlConfig;
use PHPUnit_Framework_TestCase;

/**
 * Class SamlConfig
 * @package LifeStyle\SamlAuthBundle
 */
class SamlConfigTest extends PHPUnit_Framework_TestCase
{
    const SP_NAME = "myNiceSpName";
    const IDP_APP_NAME = "myNiceSpName";

    public function testValidateGetterSetter()
    {
        $samlConfig = new SamlConfig();
        $samlConfig->setSpName(static::SP_NAME);
        $samlConfig->setIdpAppName(static::IDP_APP_NAME);
        $this->assertEquals($samlConfig->getSpName(), static::SP_NAME);
        $this->assertEquals($samlConfig->getIdpAppName(), static::IDP_APP_NAME);
    }
}
