<?php

namespace LifeStyle\SamlAuthBundle\Tests\Database;

use Liip\FunctionalTestBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use LifeStyle\SamlAuthBundle\Database\Manager as DatabaseManager;
use LifeStyle\SamlAuthBundle\Database;

/**
 * Class ApplicationTest
 * @package LifeStyle\SamlAuthBundle\Model
 */
class ManagerTest extends WebTestCase
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    public function setUp()
    {
        parent::setUp();
        $client = static::createClient();
        $this->container = $client->getContainer();
        $this->doctrineRegistry = $this->container->get('doctrine');
    }

    public function testInstances()
    {
        $dbM = new DatabaseManager($this->doctrineRegistry);
        $this->assertInstanceOf(Database\Data\Factory::class, $dbM->data());
        $this->assertInstanceOf(Database\Repository\Factory::class, $dbM->repository());
        $this->assertInstanceOf(Database\Entity\Factory::class, $dbM->entity());
        $this->assertInstanceOf(DoctrineRegistry::class, $dbM->getDoctrineRegistry());
    }
}
