<?php

namespace LifeStyle\SamlAuthBundle\Tests\DependencyInjection;

use LifeStyle\SamlAuthBundle\DependencyInjection\LifeStyleSamlAuthExtension;
use PHPUnit_Framework_TestCase;
use Symfony\Component\Yaml\Parser;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class LifeStyleSamlAuthExtensionTes
 * @package LifeStyle\SamlAuthBundle\Tests\DependencyInjection
 */
class LifeStyleSamlAuthExtensionTes extends PHPUnit_Framework_TestCase
{

    /**
     * @var ContainerBuilder
     */
    protected $configuration;

    /**
     * @expectedException \Symfony\Component\Config\Definition\Exception\InvalidConfigurationException
     */
    public function testInvalidConfiguration()
    {
        $loader = new LifeStyleSamlAuthExtension();
        $config = $this->getInvalidConfig();
        $loader->load(array($config), new ContainerBuilder());
    }

    public function testValidSpName()
    {
        $this->configuration = new ContainerBuilder();
        $loader = new LifeStyleSamlAuthExtension();
        $config = $this->getConfig();
        $config['sp_name'] = 'IamValid';
        $config['idp_app_name'] = 'IamValid';
        $loader->load(array($config), $this->configuration);
        $this->assertTrue($this->configuration->has('saml.saml_config'));
        $this->assertEquals($loader->getAlias(), 'life_style_saml_auth');
    }

    /**
     * getEmptyConfig
     *
     * @return array
     */
    protected function getInvalidConfig()
    {
        $yaml = <<<EOF
hugo: hiHow
EOF;
        $parser = new Parser();

        return $parser->parse($yaml);
    }

    /**
     * getEmptyConfig
     *
     * @return array
     */
    protected function getConfig()
    {
        $yaml = <<<EOF
sp_name: IamValid
idp_app_name: IamValid
EOF;
        $parser = new Parser();

        return $parser->parse($yaml);
    }
}
