<?php

namespace LifeStyle\SamlAuthBundle\DependencyInjection\Security\Factory;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use PHPUnit_Framework_TestCase;

class SamlFactoryTest extends PHPUnit_Framework_TestCase
{
    /**
     * @var ContainerBuilder
     */
    private $container;

    /**
     * @var SamlFactory
     */
    private $theFactory;


    public function testCreate()
    {
        $result = $this->theFactory->create(
            $this->container,
            'testid',
            ['test' => 'config'],
            'testuserprovider',
            'testentrypoint'
        );
        $this->assertEquals('security.authentication.provider.saml.testid', $result[0]);
        $this->assertEquals('security.authentication.listener.saml.testid', $result[1]);
        $this->assertEquals('testentrypoint', $result[2]);
    }

    public function testPosition()
    {
        $this->assertEquals('pre_auth', $this->theFactory->getPosition());
    }

    public function testKey()
    {
        $this->assertEquals('saml', $this->theFactory->getKey());
    }

    public function testAddConfiguration()
    {
        $nodeDefinition = $this->createMock(NodeDefinition::class);
        $this->assertNull($this->theFactory->addConfiguration($nodeDefinition));
    }


    public function setUp()
    {
        $this->container = new ContainerBuilder();
        $this->theFactory = new SamlFactory();
    }
}
