<?php

/**
 * @author buchhofer
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Form\Filter;

use Symfony\Component\Form\Test\TypeTestCase;
use LifeStyle\SamlAuthBundle\Form\Filter\UserLog as FormUserLog;

/**
 * Class UserLogTest
 * @package LifeStyle\SamlAuthBundle\Tests\Form\Filter
 */
class UserLogTest extends TypeTestCase
{
    public function testSubmitValidData()
    {
        $formData = array(
            'userName' => 'userName',
            'userEmail' => 'userEmail',
        );

        $form = $this->factory->create(FormUserLog::class);
        // submit the data to the form directly
        $form->submit($formData);
        $this->assertTrue($form->isSynchronized());
        $view = $form->createView();
        $children = $view->children;

        $this->assertEquals($form->getName(), 'user_log_filter');
        foreach (array_keys($formData) as $key) {
            $this->assertArrayHasKey($key, $children);
        }
    }
}
