<?php

namespace LifeStyle\SamlAuthBundle\Tests\Model\UserApplication;

use Liip\FunctionalTestBundle\Test\WebTestCase;
use LifeStyle\SamlAuthBundle\Model\UserApplication;

/**
 * Class ApplicationTest
 * @package LifeStyle\SamlAuthBundle\Model
 */
class ApplicationTest extends WebTestCase
{

    public function testModel()
    {
        $client = static::createClient();
        $container = $client->getContainer();
        $jmsSeralizer = $container->get('jms_serializer');

        // Deserialize test-XML
        /** @var $application UserApplication\Application */
        $application = $jmsSeralizer->deserialize($this->getXml(), UserApplication\Application::class, 'xml');

        // Test application
        $this->assertEquals('Hans', $application->getName());

        // Test app attributes
        $attributes = $application->getAttributes();
        $this->assertEquals('AttrTest', $attributes[0]->getName());
        $this->assertEquals('AttrValue', $attributes[0]->getValue());

        // Test app roles
        $roles = $application->getRoles();
        $this->assertEquals('RoleTest', $roles[0]->getName());
    }

    private function getXml()
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
                <result>
                    <name>Hans</name>
                    <attributes>
                        <entry>
                            <name>AttrTest</name>
                            <value>AttrValue</value>
                        </entry>
                    </attributes>
                    <roles>
                        <entry>
                            <name>RoleTest</name>
                        </entry>
                    </roles>
                </result>';
    }
    
    public function setUp()
    {
        parent::setUp();
    }
}
