<?php

namespace LifeStyle\SamlAuthBundle\Tests\Model\UserData;

use LifeStyle\SamlAuthBundle\Model\UserData\User as UserDto;
use LifeStyle\SamlAuthBundle\Model\UserApplication\Application as UserApplication;
use PHPUnit_Framework_TestCase;

/**
 * Class SamlConfigTest
 * @package LifeStyle\SamlAuthBundle\Tests\Model
 */
class UserTest extends PHPUnit_Framework_TestCase
{

    public function testValidateGetterSetter()
    {
        $userApplications[] = new UserApplication();
        $userApplications[] = new UserApplication();

        $userDto = new UserDto();
        $userDto->setUserGuid('userGuid');
        $userDto->setEmail('email');
        $userDto->setUsername('username');
        $userDto->setFirstname('firstname');
        $userDto->setLastname('lastname');
        $userDto->setUserId('userId');
        $userDto->setUserIdentifier('userIdentifier');
        $userDto->setUserApplicationJSONs('{"json" : true}');
        $userDto->setUserApplications($userApplications);

        $this->assertEquals('userGuid', $userDto->getUserGuid());
        $this->assertEquals('email', $userDto->getEmail());
        $this->assertEquals('username', $userDto->getUsername());
        $this->assertEquals('firstname', $userDto->getFirstname());
        $this->assertEquals('lastname', $userDto->getLastname());
        $this->assertEquals('userId', $userDto->getUserId());
        $this->assertEquals('userIdentifier', $userDto->getUserIdentifier());
        $this->assertEquals('{"json" : true}', $userDto->getUserApplicationJSONs());
        $this->assertEquals($userApplications, $userDto->getUserApplications());
    }
}
