<?php

/**
 * @author buchhofer
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Security\User;

use LifeStyle\SamlAuthBundle\Model\UserData\User as UserDto;
use LifeStyle\SamlAuthBundle\Security\User\SamlUserProvider;
use LifeStyle\SamlAuthBundle\Security\User\SamlUser;
use PHPUnit\Framework\TestCase;
use LifeStyle\SamlAuthBundle\Configuration\SamlConfig;

/**
 * Class SamlUserTest
 * @package LifeStyle\SamlAuthBundle\Tests\Security\User
 */
class SamlUserProviderTest extends TestCase
{

    public function testSamlUserProvider()
    {
        $userDto = new UserDto();
        $userDto->setUsername('Yoda');
        $config = new SamlConfig();
        $samlUserProvider = new SamlUserProvider($config);

        $this->assertInstanceOf(SamlUser::class, $samlUserProvider->loadUserFromDto($userDto));
    }

    public function testSupportsClassFalse()
    {
        $userDto = new UserDto();
        $userDto->setUsername('Yoda');
        $config = new SamlConfig();
        $samlUserProvider = new SamlUserProvider($config);

        $this->assertEquals(false, $samlUserProvider->supportsClass($userDto));
    }

    /**
     * @expectedException \Symfony\Component\Security\Core\Exception\UsernameNotFoundException
     */
    public function testUsernameNotFoundException()
    {
        $config = new SamlConfig();
        $samlUserProvider = new SamlUserProvider($config);
        $samlUserProvider->loadUserByUsername('Yoda');
    }

    /**
     * @expectedException \Symfony\Component\Security\Core\Exception\UnsupportedUserException
     */
    public function testUnsupportedUserException()
    {
        $config = new SamlConfig();
        $samlUserProvider = new SamlUserProvider($config);
        $userDto = new UserDto();
        $userDto->setUsername('Yoda');

        $samlUser = new SamlUser($userDto, ['ROLE_USER']);
        $samlUserProvider->refreshUser($samlUser);
    }
}
