<?php

/**
 * @author buchhofer
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Tests\Security\User;

use LifeStyle\SamlAuthBundle\Model\UserData\User as UserDto;
use LifeStyle\SamlAuthBundle\Security\User\SamlUser;
use PHPUnit_Framework_TestCase;

/**
 * Class SamlUserTest
 * @package LifeStyle\SamlAuthBundle\Tests\Security\User
 */
class SamlUserTest extends PHPUnit_Framework_TestCase
{

    public function testSamlUser()
    {
        $userDto = new UserDto();
        $userDto->setUsername('Yoda');

        $samlUser = new SamlUser($userDto, ['ROLE_USER']);

        $this->assertEquals(['ROLE_USER'], $samlUser->getRoles());
        $this->assertEquals(null, $samlUser->getSalt());
        $this->assertEquals(false, $samlUser->eraseCredentials());
        $this->assertEquals('Yoda', $samlUser->getUsername());
        $this->assertEquals(null, $samlUser->getPassword());
        $this->assertInstanceOf(SamlUser::class, $samlUser);
        $this->assertInstanceOf(UserDto::class, $samlUser->getUserSamlData());
        $this->assertEquals($samlUser, 'Yoda');
        $this->assertEquals(true, $samlUser->isEqualTo($samlUser));
    }
}
