<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\SamlAuthBundle\Twig\Extension;

use Symfony\Component\Security\Core\SecurityContext;

/**
 * Class SAML
 * @package LifeStyle\SamlAuthBundle\Twig\Extension
 */
class SAML extends \Twig_Extension implements \Twig_Extension_GlobalsInterface
{
    /**
     * @return array
     */
    public function getGlobals()
    {
        return array(
            'isSamlActive' => $this->isSamlActive()
        );
    }

    /**
     * @return bool
     */
    private function isSamlActive()
    {
        return 1 != getenv('DISABLE_SSO_LOGIN');
    }
}
