<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use LifeStyle\Tools\CredentialsBundle\Entity\Token;

/**
 * Class LoadTokens
 * @package LifeStyle\Tools\CredentialsBundle\DataFixtures\ORM
 */
class LoadTokens extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        $tomorrow = new \DateTime();
        $tomorrow->add(new \DateInterval('P1D'));
        $rows = array(
            array(
                'X2222cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYacOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa',
                '*',
                100,
                $tomorrow,
                0,
                null,
                'Default entry for testing'
            )
        );
        foreach ($rows as $row) {
            $entity = new Token();
            $entity->setServiceToken($row[0])
                ->setServiceToken2Ip($row[1])
                ->setAllowedCallsPerDay($row[2])
                ->setValidUntil($row[3])
                ->setBlocked($row[4])
                ->setBlockedReason($row[5])
                ->setDescription($row[6]);
            $manager->persist($entity);
        }
        $manager->flush();
    }

    /**
     * {@inheritDoc}
     */
    public function getOrder()
    {
        return 3;
    }

}
